/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

public enum ResourceState {
    ONLINE("STATE=ONLINE", "ONLINE"),
    OFFLINE("STATE=OFFLINE", "OFFLINE"),
    INTERMEDIATE("STATE=INTERMEDIATE", "INTERMEDIATE"),
    UNKNOWN("UNKNOWN", "UNKNOWN");

    private String searchPattern;
    private static String targetOffline;
    private String state;

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    private ResourceState(String pattern, String state) {
        this.searchPattern = pattern;
        this.state = state;
    }

    public static ResourceState checkState(String status) {
        if (status.indexOf(targetOffline) != -1) {
            return OFFLINE;
        }
        for (ResourceState st : ResourceState.values()) {
            if (status.indexOf(st.searchPattern) == -1) continue;
            return st;
        }
        return UNKNOWN;
    }

    static {
        targetOffline = "TARGET=OFFLINE";
    }
}

